package dtelements;

import java.util.ArrayList;

public class Attribute {
	
	private String name;
	private ArrayList<String> domain;
	
	public Attribute(String name, ArrayList<String> domain)
	{
		this.name = name;
		this.domain = domain;
	}

	public String getName() {
		return name;
	}

	public ArrayList<String> getDomain() {
		return domain;
	}
	
	public boolean equals(Object o)
	{
		if(o instanceof Attribute)
		{
			if(this.name.equals(((Attribute)o).getName()))
			{
				return true;
			}
		}
		
		return false;
	}
	
	public int hasCode()
	{
		return this.name.hashCode();
	}
	
	public String toString()
	{
		String ret = name + "{";
		
		for(int i = 0; i < this.domain.size()-1; i++)
		{
			ret += this.domain.get(i) + ",";
		}
		
		ret += this.domain.get(this.domain.size()-1) + "}";
		
		return ret;
	}

	@SuppressWarnings("unchecked")
	public Attribute clone()
	{
		return (new Attribute(name, (ArrayList<String>)domain.clone()));
	}
}
